import subprocess
import json
from mail.monitoring.common.tskv import parse_tskv

TSKV_FORMATS = ["tskv", "tskv2"]


def timetail(log_file, fmt="common", time=60):
    str_log = ("timetail -t " + fmt + " -n " + str(time) + " " + log_file).split()
    p = subprocess.Popen(str_log, stdout=subprocess.PIPE)
    log = p.communicate()[0].splitlines()

    if fmt in TSKV_FORMATS:
        log = [parse_tskv(line) for line in log]

    if fmt == "nginx-json":
        log = [json.loads(line) for line in log]

    return log
