#!/usr/sbin/monpy

import re
from mail.monitoring.common.graphite import get_graphite_prefix, timestamp
from mail.monitoring.common.timetail import timetail
from mail.monitoring.delivery.lib import mdbsave

LOG_FILE = "/var/log/mdbsave/mdbsave.log"
TIMETAIL_FMT = "imap"

if __name__ == "__main__":

    log_cached = timetail(LOG_FILE, fmt=TIMETAIL_FMT, time=60)

    def get_log_cached(LOG_FILE, time, fmt):
        return log_cached

    failed_shards = mdbsave.get_errors_count_per_shard(get_logs=get_log_cached)

    for shard, count in failed_shards.iteritems():
        print "%s.mdbsave.shard_errors.%s %d %d" % (get_graphite_prefix(), shard, count, timestamp)
