#!/usr/sbin/monpy

from mail.monitoring.common.graphite import get_graphite_prefix, timestamp
from mail.monitoring.delivery.lib.nsls import get_all_http_stat


def main():
    for service, info in get_all_http_stat().iteritems():
        for code, count in info["http_codes"].iteritems():
            print "%s.nsls.http.codes.%s.%s %d %d" % (get_graphite_prefix(), service, code, count, timestamp)
        for timing, count in info["timing_buckets"].iteritems():
            print "%s.nsls.http.timings.%s.%s %d %d" % (get_graphite_prefix(), service, timing, count, timestamp)


if __name__ == "__main__":
    main()
