#!/usr/sbin/monpy

from mail.monitoring.common.graphite import get_graphite_prefix, timestamp
from mail.monitoring.delivery.lib.nsls import get_msg_delay_stat


def main():
    types = ["in", "out", "dlv"]
    timing_buckets = (100, 200, 300, 400, 500, 600, 700, 800, 900, 1000, 2000, 3000, 4000, 5000, 6000, 7000, 8000, 9000, 10000)
    sum = 0
    for type, timings in get_msg_delay_stat(types, timing_buckets=timing_buckets).iteritems():
        for timing, count in timings.iteritems():
            sum += count
            print "%s.nsls.msg_delay.%s.%s %d %d" % (get_graphite_prefix(), type, timing, count, timestamp)
    print "%s.nsls.msg_delay.sum %d %d" % (get_graphite_prefix(), sum / len(types), timestamp)

if __name__ == "__main__":
    main()
