#!/usr/sbin/monpy
# -*- coding: UTF-8 -*-

import re
from mail.monitoring.common.graphite import get_graphite_prefix, timestamp
from mail.monitoring.common.maillog import get_maillog

YANDEX_TLD_FILE = "/var/yamail-dkim/opendkim-domains"


with open(YANDEX_TLD_FILE) as f:
    DOMAINS_YANDEX = f.read().splitlines()


yandex_domains = 0
pdd_domains = 0

for line in get_maillog():
    if re.search("DKIM: added a signature for", line):
        domain = line.split("@")[1]
        if domain in DOMAINS_YANDEX:
            yandex_domains += 1
        else:
            pdd_domains += 1

print "%s.nwsmtp.dkim.yandex_domains %d %d" % (get_graphite_prefix(), yandex_domains, timestamp)
print "%s.nwsmtp.dkim.pdd_domains %d %d" % (get_graphite_prefix(), pdd_domains, timestamp)
