#!/usr/sbin/monpy
# -*- coding: UTF-8 -*-

import subprocess
import re
from mail.monitoring.common.graphite import project, host, cond_group, timestamp

import GeoIP

log_file = '/var/log/maillog'

str_log = ('timetail -t syslog -n 60 ' + log_file).split()
p = subprocess.Popen(str_log, stdout=subprocess.PIPE)
log = p.communicate()[0].splitlines()

regions = {}
gi = GeoIP.new(GeoIP.GEOIP_MEMORY_CACHE)
gi = GeoIP.open("/usr/share/GeoIP/GeoIP.dat", GeoIP.GEOIP_STANDARD)

nw_connect = re.compile('status=')

for line in log:
    if nw_connect.search(line):
        status = re.sub('.*status=', '', line).split()[0]
        try:
            ip = line.split('[')[2].split(']')[0]
            region = gi.country_name_by_addr(ip)
            if regions.get(region) is None:
                regions[region] = {}
            regions[region][status] = regions.get(region).get(status, 0) + 1

        except:
            pass


for reg in regions:
    region = str(reg)
    region = re.sub(' ', '_', region)
    region = re.sub(',', '', region)
    for status in regions[reg]:
        count = regions[reg][status]
        print "%s.%s.%s.%s.%s.%s %d %d" % (project, cond_group, host, 'region', region, status, count, timestamp)
