#!/usr/bin/perl


my $app="postfix";

#######################################################################################################
my $project="mail";

our $hostname=`hostname -f`;
chomp $hostname;


if (!($cond_group=`cat /var/cond_group 2>/dev/null`)) {
        $gr="wget -q --tries=3 -O - http://c.yandex-team.ru/api/hosts2groups/".$hostname."|head -n1";
        $cond_group=`$gr`;
        chomp $cond_group;
        `echo $cond_group > /var/cond_group`
}
chomp $cond_group;

$timestamp=`date +%s`;
chomp $timestamp;

$hostname=~s/\./_/g;
##########################################################################################################

#use zabbix_sender;
use Time::Local;
use POSIX;
use Fcntl qw(:flock);


my $BIGQUEUE=5000;
my $AGE_TRESHOLD=86400; # In seconds

my $postfixstatussent=0;
my $postfixstatusbounced=0;
my $postfixstatusdeferred=0;
my $postfixstatusexpired=0;

my $postfixrelayfastsrv=0;
my $postfixrelayforwards=0;
my $postfixrelaymxbacks=0;
my $postfixrelayyabacks=0;
my $postfixrelayservices=0;
my $postfixrelayothers=0;

my $postfixsize=0;

my $postfixdelay0x1=0;
my $postfixdelay1x3=0;
my $postfixdelay3x10=0;
my $postfixdelay10x60=0;
my $postfixdelay60xinf=0;

my $postfixclientmxfront=0;
my $postfixclientmxback=0;
my $postfixclientyaback=0;
my $postfixclientmxcorp=0;
my $postfixclientsmtp=0;
my $postfixclientsmtpcorp=0;
my $postfixclientweb=0;
my $postfixclientwebcorp=0;
my $postfixclientother=0;

my $postfixtrustedtls=0;
my $postfixuntrustedtls=0;

my $postfixdbproblemlockmailbox=0;
my $postfixdbproblemserviceunspecified=0;
my $postfixdbproblemkilledsession=0;
my $postfixdbproblemendoffile=0;
my $postfixdbproblemconnectionwaiting=0;
my $postfixdbproblemother=0;

#my $max_age=0;
my $old_letters=0;
#my $search_queue=0;

open (MAILLOG, "/usr/bin/mymtail.sh /var/log/maillog $app |");

while ($line=<MAILLOG>)
{
	if($line =~ m/postfix\/.*, status=(\w+).*/) {
		if($1 eq "sent") {
			$postfixstatussent++;
		} elsif($1 eq "bounced") {
			$postfixstatusbounced++;
		} elsif($1 eq "deferred") {
			$postfixstatusdeferred++;
		} elsif($1 eq "expired") {
			$postfixstatusexpired++;
		}
	}

	if($line =~ m/postfix\/.*, relay=([a-zA-Z0-9\.]+).*, delay=([0-9\.]+), .*, status=sent.*/) {
		if($1 eq "127.0.0.1") {
			$postfixrelayfastsrv++;
		} elsif($1 eq "fastsrv.mail.yandex.net") {
			$postfixrelayfastsrv++;
		} elsif($1 eq "forwards.mail.yandex.net") {
			$postfixrelayforwards++;
		} elsif($1 eq "mxbacks.mail.yandex.net") {
			$postfixrelaymxbacks++;
		} elsif($1 eq "yabacks.mail.yandex.net") {
                        $postfixrelayyabacks++;
		} elsif($1 eq "services.mail.yandex.net") {
                        $postfixrelayservices++;
                } else {
                        $postfixrelayothers++;
                }
	}

	if($line =~ m/postfix\/qmgr.*, size=(\d+), /) {
		$postfixsize += $1;
	}
	
	if($line =~ m/postfix\/smtp.*, delay=(\d+)/) {
		#$postfixdelay += $1;
		if($1<=100) {
			$postfixdelay0x1++;
		} elsif($1<=300) {
                        $postfixdelay1x3++;
		} elsif($1<=1000) {
			$postfixdelay3x10++;
		} elsif($1<=6000) {
			$postfixdelay10x60++;
		} else {
			$postfixdelay60xinf++;
		}

	}

	if($line =~ m/ymilter: failed to mark user activity/) {
		$postfixfailmarkuseractivity++;
	}
	
	if($line =~ m/postfix\/.*: Trusted TLS connection established/) {
		$postfixtrustedtls++;
	}
	
	if($line =~ m/postfix\/.*: Untrusted TLS connection established/) {
		$postfixuntrustedtls++;
	}

	if($line =~ m/postfix\/smtpd.*: client=(\w+)\./) {
		if($1 =~ /mxfront[0-9]+/) {
			$postfixclientmxfront++;
		} elsif($1 =~ /mxback[0-9]+/) {
			$postfixclientmxback++;
		} elsif($1 =~ /yaback[0-9]+/) {
			$postfixclientyaback++;
		} elsif($1 =~ /mxcorp[0-9]+/) {
			$postfixclientmxcorp++;
		} elsif($1 =~ /smtp[0-9]+/) {
			$postfixclientsmtp++;
		} elsif($1 =~ /smtpcorp[0-9]+/) {
			$postfixclientsmtpcorp++;
		} elsif($1 =~ /web[0-9]+/) {
			$postfixclientweb++;
		} elsif($1 =~ /webcorp[0-9]+/) {
			$postfixclientwebcorp++;
		} else {
			$postfixclientother++;
		}
	}

}

close MAILLOG;

my $postfixmailq=`pmailq`;
chomp $postfixmailq;

my $postfixconnections=`ss -n -o state established|fgrep -c ':25 '`;
chomp $postfixconnections;

my $postfixsmtpd=`pidof smtpd|wc -w`;
chomp $postfixsmtpd;

if ($postfixmailq<$BIGQUEUE) {
	open (LOCK, "/usr/lib/yamail-mx-monitor/graphite/postfix.pl") || die "Cannot lock file";
        flock (LOCK, LOCK_EX|LOCK_NB) || die "Script already runnig";
        open (DBPROBLEM, "fgrep -r 'diag_text=451 4.5.0 internal mail db error' /var/spool/postfix/defer/|cut -d';' -f2|sort|uniq|while read rec; do tail -100000 /var/log/maillog | fgrep \$rec | fgrep 'db problem' ; done |");
        while (my $line=<DBPROBLEM>){
                if($line =~ m/ORA-20104: Timed out while acquiring lock/) {
                        $postfixdbproblemlockmailbox++;
                } elsif($line =~ m/ORA-12162: TNS:net service name is incorrectly specified/) {
                        $postfixdbproblemserviceunspecified++;
                } elsif($line =~ m/sql execute error: ORA-00028: your session has been killed/) {
                        $postfixdbproblemkilledsession++;
                } elsif($line =~ m/ORA-03113: end-of-file on communication channel Process ID/) {
                        $postfixdbproblemendoffile++;
                } elsif($line =~ m/Timed out while waiting for a free connection to/) {
                        $postfixdbproblemconnectionwaiting++;
                } else {
                        $postfixdbproblemother++;
                }
        }
        close DBPROBLEM;
	open(QUEUE,"postqueue -p | egrep '(@|MAILER-DAEMON)' | grep -v '(' | awk '\$2 {print \$4,\$5,\$6}'|");
	my $year = `date '+%Y'`;
	my $now = timelocal(`date '+%S'`,`date '+%M'`,`date '+%H'`,`date '+%d'`,`date '+%b'`,$year);
	while (my $line=<QUEUE>) {
        	if ($line =~ m/(\w{3})\s(\d+)\s(\d+):(\d+):(\d+)/)
       		{
               		my $timestamp = timelocal($5,$4,$3,$2,$1,$year);
	                #if (($now - $timestamp) > $max_age) {$max_age = $now - $timestamp;}
       		        if (($now - $timestamp) > $AGE_TRESHOLD)
               		{
                       		$old_letters++;
               		}	
       		}
	}

	close(QUEUE);

        open(LASTVALUE,"> /tmp/mtail/postfix");
        print(LASTVALUE "$postfixdbproblemlockmailbox\n$postfixdbproblemserviceunspecified\n$postfixdbproblemkilledsession\n$postfixdbproblemendoffile\n$postfixdbproblemconnectionwaiting\n$postfixdbproblemother\n$old_letters");
        close LASTVALUE;
	close(LOCK);
} else {
        open(LASTVALUE,"/tmp/mtail/postfix");
        chomp; $postfixdbproblemlockmailbox=<LASTVALUE>;
        chomp; $postfixdbproblemserviceunspecified=<LASTVALUE>;
        chomp; $postfixdbproblemkilledsession=<LASTVALUE>;
        chomp; $postfixdbproblemendoffile=<LASTVALUE>;
        chomp; $postfixdbproblemconnectionwaiting=<LASTVALUE>;
        chomp; $postfixdbproblemother=<LASTVALUE>;
	chomp; $old_letters=<LASTVALUE>;
        close LASTVALUE;
}

print $project,".",$main::cond_group,".",$main::hostname,".postfix.status.sent ",$postfixstatussent," ",$timestamp,"\n";
print $project,".",$main::cond_group,".",$main::hostname,".postfix.status.bounced ",$postfixstatusbounced," ",$timestamp,"\n";
print $project,".",$main::cond_group,".",$main::hostname,".postfix.status.deferred ",$postfixstatusdeferred," ",$timestamp,"\n";
print $project,".",$main::cond_group,".",$main::hostname,".postfix.status.expired ",$postfixstatusexpired," ",$timestamp,"\n";

print $project,".",$main::cond_group,".",$main::hostname,".postfix.relay.fastsrv ",$postfixrelayfastsrv," ",$timestamp,"\n";
print $project,".",$main::cond_group,".",$main::hostname,".postfix.relay.forwards ",$postfixrelayforwards," ",$timestamp,"\n";
print $project,".",$main::cond_group,".",$main::hostname,".postfix.relay.mxbacks ",$postfixrelaymxbacks," ",$timestamp,"\n";
print $project,".",$main::cond_group,".",$main::hostname,".postfix.relay.yabacks ",$postfixrelayyabacks," ",$timestamp,"\n";
print $project,".",$main::cond_group,".",$main::hostname,".postfix.relay.services ",$postfixrelayservices," ",$timestamp,"\n";
print $project,".",$main::cond_group,".",$main::hostname,".postfix.relay.others ",$postfixrelayothers," ",$timestamp,"\n";

print $project,".",$main::cond_group,".",$main::hostname,".postfix.size ",$postfixsize," ",$timestamp,"\n";

print $project,".",$main::cond_group,".",$main::hostname,".postfix.delay.0x1 ",$postfixdelay0x1," ",$timestamp,"\n";
print $project,".",$main::cond_group,".",$main::hostname,".postfix.delay.1x3 ",$postfixdelay1x3," ",$timestamp,"\n";
print $project,".",$main::cond_group,".",$main::hostname,".postfix.delay.3x10 ",$postfixdelay3x10," ",$timestamp,"\n";
print $project,".",$main::cond_group,".",$main::hostname,".postfix.delay.10x60 ",$postfixdelay10x60," ",$timestamp,"\n";
print $project,".",$main::cond_group,".",$main::hostname,".postfix.delay.60xinf ",$postfixdelay60xinf," ",$timestamp,"\n";

print $project,".",$main::cond_group,".",$main::hostname,".postfix.mailq.mailq ",$postfixmailq," ",$timestamp,"\n";
print $project,".",$main::cond_group,".",$main::hostname,".postfix.mailq.old ",$old_letters," ",$timestamp,"\n";
print $project,".",$main::cond_group,".",$main::hostname,".postfix.connections ",$postfixconnections," ",$timestamp,"\n";
print $project,".",$main::cond_group,".",$main::hostname,".postfix.smtpd ",$postfixsmtpd," ",$timestamp,"\n";

print $project,".",$main::cond_group,".",$main::hostname,".postfix.ssl.trustedtls ",$postfixtrustedtls," ",$timestamp,"\n";
print $project,".",$main::cond_group,".",$main::hostname,".postfix.ssl.untrustedtls ",$postfixuntrustedtls," ",$timestamp,"\n";

print $project,".",$main::cond_group,".",$main::hostname,".postfix.failmarkuseractivity ",$postfixfailmarkuseractivity," ",$timestamp,"\n";

print $project,".",$main::cond_group,".",$main::hostname,".postfix.client.mxfront ",$postfixclientmxfront," ",$timestamp,"\n";
print $project,".",$main::cond_group,".",$main::hostname,".postfix.client.mxback ",$postfixclientmxback," ",$timestamp,"\n";
print $project,".",$main::cond_group,".",$main::hostname,".postfix.client.yaback ",$postfixclientyaback," ",$timestamp,"\n";
print $project,".",$main::cond_group,".",$main::hostname,".postfix.client.mxcorp ",$postfixclientmxcorp," ",$timestamp,"\n";
print $project,".",$main::cond_group,".",$main::hostname,".postfix.client.smtp ",$postfixclientsmtp," ",$timestamp,"\n";
print $project,".",$main::cond_group,".",$main::hostname,".postfix.client.smtpcorp ",$postfixclientsmtpcorp," ",$timestamp,"\n";
print $project,".",$main::cond_group,".",$main::hostname,".postfix.client.web ",$postfixclientweb," ",$timestamp,"\n";
print $project,".",$main::cond_group,".",$main::hostname,".postfix.client.webcorp ",$postfixclientwebcorp," ",$timestamp,"\n";
print $project,".",$main::cond_group,".",$main::hostname,".postfix.client.other ",$postfixclientother," ",$timestamp,"\n";

print $project,".",$main::cond_group,".",$main::hostname,".postfix.db_problem.lockmailbox ",$postfixdbproblemlockmailbox," ",$timestamp,"\n";
print $project,".",$main::cond_group,".",$main::hostname,".postfix.db_problem.serviceunspecified ",$postfixdbproblemserviceunspecified," ",$timestamp,"\n";
print $project,".",$main::cond_group,".",$main::hostname,".postfix.db_problem.killedsession ",$postfixdbproblemkilledsession," ",$timestamp,"\n";
print $project,".",$main::cond_group,".",$main::hostname,".postfix.db_problem.endoffile ",$postfixdbproblemendoffile," ",$timestamp,"\n";
print $project,".",$main::cond_group,".",$main::hostname,".postfix.db_problem.connectionwaiting ",$postfixdbproblemconnectionwaiting," ",$timestamp,"\n";
print $project,".",$main::cond_group,".",$main::hostname,".postfix.db_problem.other ",$postfixdbproblemother," ",$timestamp,"\n";
