import re
import socket
from collections import defaultdict
from IPy import IP

from mail.monitoring.common.maillog import get_maillog
from mail.monitoring.common import qloud


hostname = socket.gethostname()


def check_port(port, timeout=3, host="127.0.0.1", banner=""):
    # Codes:
    # 0 - connection refused
    # 1 - connection timeout (successed)
    # 2 - banner matched
    try:
        ip_family = socket.AF_INET
        if IP(host).version() == 6:
            ip_family = socket.AF_INET6

        sock = socket.socket(ip_family)
        sock.connect((host, port))
        sock.settimeout(timeout)
        if banner:
            sock_banner = sock.recv(128)
            if re.search(banner, sock_banner):
                return 2
        return 1
    except socket.error, msg:
        if msg.__str__() == "timed out":
            return 1
        return 0


def get_delivery_statuses(app="", time=60):
    delivery_statuses = defaultdict(int)
    status_re = re.compile(app + r".*:.*status=(?P<status>\w+)")

    for line in get_maillog(time=time):
        match = status_re.search(line)
        if match:
            delivery_statuses[match.group('status')] += 1
    return delivery_statuses


def get_mail_type():
    return qloud.environ.user.get("MAIL_TYPE")
