import re
from collections import defaultdict
from mail.monitoring.common.maillog import get_maillog


def get_errors_count_per_shard():
    errors_count_per_shard = defaultdict(int)
    error_re = re.compile(r'fastsrv.*query failed with.*host=(?P<db>xdb\d+)')
    for line in get_maillog(time=60):
        match = error_re.search(line)
        if match:
            errors_count_per_shard[match.group('db')] += 1
    return errors_count_per_shard
