import os
import tempfile

from library.python import resource

import GeoIP


def get_geo():
    """ Initialize GeoIP instance with GeoIP.dat (standard DB type).

        `libGeoIP` requires path to file, not buffer or something else,
            so we obtain resource from bin and store it into tmp file to
            skip deploy and package dependencies.
    """
    geo_dat = resource.find("GeoIP.dat")
    _, path = tempfile.mkstemp()
    try:
        with open(path, "wb") as fd:
            fd.write(geo_dat)
            return GeoIP.open(path, GeoIP.GEOIP_STANDARD)
    finally:
        os.unlink(path)
