import json
import os
import re
import subprocess
from mail.monitoring.common.maillog import get_maillog

POSTFIX_GET_QUEUE_SIZE_CMD = "find /var/spool/postfix/{QUEUE}/ -type f 2>/dev/null"

HOLD_FILE = '/var/tmp/postfix_hold.lst'
HOLD_AMOUNT_FILE = HOLD_FILE + '.amount'


def get_autohold_queue_size():
    amount = 0
    try:
        if os.path.isfile(HOLD_AMOUNT_FILE):
            with open(HOLD_AMOUNT_FILE, 'r') as amount_file:
                amount += int(amount_file.readline())
    except:
        pass
    return amount


def get_mailer_daemon_queue_size():
    queue_size = 0
    for queue_item in get_queue_data():
        if queue_item["sender"] == "MAILER-DAEMON":
            queue_size += 1
    return queue_size


def get_queue_size(queue):

    if queue == "autohold":
        return get_autohold_queue_size()
    if queue == "mailer_daemon":
        return get_mailer_daemon_queue_size()

    cmd = POSTFIX_GET_QUEUE_SIZE_CMD.format(QUEUE=queue)
    queue_size = len(os.popen(cmd).read().splitlines())

    if queue == "hold":
        queue_size -= get_autohold_queue_size()
        if queue_size < 0:
            queue_size = 0

    if queue == "deferred":
        queue_size -= get_mailer_daemon_queue_size()
        if queue_size < 0:
            queue_size = 0

    return queue_size


def get_queue_data(queue_name="deferred"):
    queue_lines = os.popen("postqueue -j").read().splitlines()
    queue = filter(lambda q: q["queue_name"] == queue_name, map(lambda line: json.loads(line), queue_lines))
    return queue


def get_sent_timings(time=60):
    timings = []
    timings_re = re.compile("delay=(?P<delay>.*), delays.*status=sent")
    for line in get_maillog(time=time):
        match = timings_re.search(line)
        if match:
            timings.append(float(match.group('delay')))
    return timings


def hold_ids(ids):
    cmd = "postsuper -h -"
    postfix_super = cmd.split()
    p = subprocess.Popen(postfix_super, stdin=subprocess.PIPE)
    p.communicate('\n'.join(ids) + '\n')


def delete_ids(ids):
    cmd = "postsuper -d -"
    postfix_super = cmd.split()
    p = subprocess.Popen(postfix_super, stdin=subprocess.PIPE)
    p.communicate('\n'.join(ids) + '\n')
