#!/bin/bash

while getopts "f:t:" OPTION
do
    case $OPTION in
        f)
            FILENAME="$OPTARG"
        ;;
        t)
            TTL="$OPTARG"
        ;;
    esac
done

function usage() {
    echo "Usage:"
    echo $0" -f <filename> -t <ttl in seconds>"
}

if [ -z "$FILENAME" ] || [ -z "$TTL" ];then
    usage
    exit
fi

FILE_LAST_UPDATE=$(date +%s -r $FILENAME)
CURRENT_TIME=$(date +%s)

FILE_RECENCY=$((CURRENT_TIME-FILE_LAST_UPDATE))

status=0
if [ $FILE_RECENCY -gt $TTL ];then
    status=2
fi

echo $status";File recency: "$FILE_RECENCY" sec"

