#!/usr/sbin/monpy
# -*- coding: UTF-8 -*-

import argparse
import time
from mail.monitoring.common import monrun
from mail.monitoring.delivery.lib.common import check_port, hostname


def main(args):
    for i in xrange(args.retry):
        check_port_result = check_port(args.port, banner=hostname)
        if check_port_result == 2:
            break
        time.sleep(args.retry_timeout)

    if check_port_result == 0:
        status = monrun.CRITICAL
        description = "port " + str(args.port) + " is down"
    if check_port_result == 1:
        status = monrun.CRITICAL
        description = "can't get banner from port " + str(args.port)
    if check_port_result == 2:
        status = monrun.OK
        description = "OK"
    monrun.report(status, description)

if __name__ == "__main__":
    parser = argparse.ArgumentParser(
        description=("Checks smtp server is alive"))
    parser.add_argument("-p", "--port", dest="port", type=int, default=25, required=False,
                        help="smtp port")
    parser.add_argument("--retry", type=int, default=1, required=False, help="retry count")
    parser.add_argument("--retry-timeout", type=int, default=1, required=False, help="retry timeout")
    args = parser.parse_args()
    main(args)
