#!/usr/sbin/monpy
# -*- coding: UTF-8 -*-

import argparse
from mail.monitoring.common import monrun
from mail.monitoring.delivery.lib.fastsrv import get_errors_count_per_shard

DEFAULT_ALL_DB_ERRORS_LIMIT = 400
DEFAULT_PER_DB_ERRORS_LIMIT = 220


def main(args):
    errors_count_per_shard = get_errors_count_per_shard()

    status = monrun.OK
    if sum(errors_count_per_shard.values()) > args.all_db_limit:
        status = monrun.CRITICAL
    for shard, errors in errors_count_per_shard.iteritems():
        if errors > args.per_db_limit:
            status = monrun.CRITICAL

    monrun.report(status, errors_count_per_shard)


if __name__ == "__main__":
    parser = argparse.ArgumentParser(
        description=("Checks postgres shards error"))

    parser.add_argument("-a", "--all-db-limit", type=int,
                        default=DEFAULT_ALL_DB_ERRORS_LIMIT, help="Maximum postgres errors for all shards, limit")
    parser.add_argument("-d", "--per-db-limit", type=int,
                        default=DEFAULT_PER_DB_ERRORS_LIMIT, help="Maximum postgres errors per shards, limit")

    args = parser.parse_args()
    main(args)
