#!/usr/sbin/monpy
# -*- coding: UTF-8 -*-

import argparse
from mail.monitoring.common import monrun
from mail.monitoring.delivery.lib import mdbsave
from mail.monitoring.common.timetail import timetail


DEFAULT_DB_ERRORS_PERC = 2


def main(args):
    log_cached = timetail(mdbsave.LOG_FILE, fmt=mdbsave.TIMETAIL_FMT, time=args.interval)

    def get_log_cached(LOG_FILE, time, fmt):
        return log_cached

    db_errors = mdbsave.get_db_errors(get_logs=get_log_cached)
    db_errors_count = sum(db_errors.values())

    success_save_count = mdbsave.get_success_save_count(get_logs=get_log_cached)

    status = monrun.OK
    if success_save_count:
        errors_percent = db_errors_count / \
            (success_save_count + db_errors_count) * 100
        if errors_percent > args.crit_perc:
            status = monrun.CRITICAL

    monrun.report(status, db_errors)


if __name__ == "__main__":
    parser = argparse.ArgumentParser(
        description=("Checks postgres shards error"))

    parser.add_argument("-c", "--crit-perc", type=int,
                        default=DEFAULT_DB_ERRORS_PERC, help="DB errors crit percent")
    parser.add_argument("-t", "--time", dest="interval", type=int, default=60, required=False,
                        help="Time interval(seconds) to perform check for")

    args = parser.parse_args()
    main(args)
