#!/usr/sbin/monpy
# -*- coding: UTF-8 -*-

import argparse
from requests.exceptions import RequestException
from mail.monitoring.common import monrun
from mail.monitoring.delivery.lib import mdbsave


DEFAULT_ALL_DB_ERRORS_LIMIT = 400
DEFAULT_PER_DB_ERRORS_LIMIT = 175


def main(args):
    try:
        errors_count_per_shard = mdbsave.get_errors_count_per_shard(time=args.interval)
    except RequestException as e:
        monrun.report(monrun.CRITICAL, "sharpei connection error: %s" % e)
        return 0

    status = monrun.OK
    if sum(errors_count_per_shard.values()) > args.all_db_limit:
        status = monrun.CRITICAL
    for shard, errors in errors_count_per_shard.iteritems():
        if errors > args.per_db_limit:
            status = monrun.CRITICAL

    monrun.report(status, errors_count_per_shard)


if __name__ == "__main__":
    parser = argparse.ArgumentParser(
        description=("Checks postgres shards error"))

    parser.add_argument("-a", "--all-db-limit", type=int,
                        default=DEFAULT_ALL_DB_ERRORS_LIMIT, help="Maximum postgres errors for all shards, limit")
    parser.add_argument("-d", "--per-db-limit", type=int,
                        default=DEFAULT_PER_DB_ERRORS_LIMIT, help="Maximum postgres errors per shards, limit")
    parser.add_argument("-t", "--time", dest="interval", type=int, default=60, required=False,
                        help="Time interval(seconds) to perform check for")
    args = parser.parse_args()
    main(args)
