#!/usr/sbin/monpy

import argparse
from mail.monitoring.common import monrun
from mail.monitoring.delivery.lib import nsls


LIMIT_CRIT = 10
LIMIT_WARN = 5
LIMIT_NOT_FOUND = 40


def main(service, limit_crit, limit_warn, limit_not_found, log_path, timefmt, time):
    status = monrun.OK

    info = nsls.get_http_stat(service, log_path, timefmt, time)
    total = sum(info['http_codes'].itervalues())

    if total != 0:
        codes_error_count = sum([count for code, count in info["http_codes"].iteritems() if code >= 500 or code == 0])
        codes_error_perc = float(codes_error_count) / total * 100
        codes_4xx_count = sum([count for code, count in info["http_codes"].iteritems() if code in xrange(400, 500)])
        codes_4xx_perc = float(codes_4xx_count) / total * 100

        if codes_error_perc > limit_warn:
            status = monrun.WARNING
        if codes_error_perc > limit_crit or codes_4xx_perc > limit_not_found:
            status = monrun.CRITICAL
    monrun.report(status, info["http_codes"])


if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="Checks various http external services response codes")
    parser.add_argument("-s", "--service", dest="service", choices=nsls.SERVICES, required=True,
                        help="Service prefix")
    parser.add_argument("-l", "--log", dest="log_path", type=str, default=nsls.HTTP_CLIENT_LOG_PATH,
                        help="Log path")
    parser.add_argument("-f", "--time-fmt", dest="timefmt", type=str, default=nsls.TIMETAIL_FMT,
                        help="Log time format (see timetail(1))")
    parser.add_argument("-t", "--time", dest="time", type=int, default=60,
                        help="Time interval (seconds) to perform checks for")
    parser.add_argument("-c", "--crit-percent", dest="limit_crit", type=int, default=LIMIT_CRIT,
                        help="Critical errors limit, in %%")
    parser.add_argument("-w", "--warn-percent", dest="limit_warn", type=int, default=LIMIT_WARN,
                        help="Warning errors limit, in %%")
    parser.add_argument("-n", "--not-found-percent", dest="limit_not_found", type=int, default=LIMIT_NOT_FOUND,
                        help="Critical not-found errors limit, in %%")
    args = parser.parse_args()
    main(**dict(args._get_kwargs()))
