#!/usr/sbin/monpy

import argparse
from mail.monitoring.common import monrun
from mail.monitoring.delivery.lib import nsls


PERCENT_CRIT = 100
PERCENT_WARN = 20


def main(percent_crit, percent_warn, log_path, timefmt, time):
    status = monrun.OK

    codes = nsls.get_reply_codes(log_path, timefmt, time)
    total = sum(codes.itervalues())

    if total != 0:
        percent_errors = 100 - float(codes["2xx"]) / total * 100

        if percent_errors >= percent_crit:
            status = monrun.CRITICAL
        elif percent_errors >= percent_warn:
            status = monrun.WARNING

    monrun.report(status, codes)


if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="Checks NSLS response codes")
    parser.add_argument("-l", "--log", dest="log_path", type=str, default=nsls.NSLS_LOG_PATH,
                        help="Log path")
    parser.add_argument("-f", "--time-fmt", dest="timefmt", type=str, default=nsls.TIMETAIL_FMT,
                        help="Log time format (see timetail(1))")
    parser.add_argument("-t", "--time", dest="time", type=int, default=60,
                        help="Time interval (seconds) to perform checks for")
    parser.add_argument("-c", "--crit-percent", dest="percent_crit", type=int, default=PERCENT_CRIT,
                        help="Critical errors limit, in %%")
    parser.add_argument("-w", "--warn-percent", dest="percent_warn", type=int, default=PERCENT_WARN,
                        help="Warning errors limit, in %%")
    args = parser.parse_args()
    main(**dict(args._get_kwargs()))
