#!/usr/sbin/monpy
# -*- coding: UTF-8 -*-

import argparse
from mail.monitoring.common import monrun
from mail.monitoring.delivery.lib import nwsmtp

WARN_PERC = 10
CRIT_PERC = 20


def main(args):
    status = monrun.OK

    avir_statuses = nwsmtp.get_avir_statuses(avir_type=args.avir_type, app=args.app)
    avir_statuses_sum = sum([i for i in avir_statuses.values()])

    if avir_statuses_sum:
        unknown_perc = float(avir_statuses['unknown']) / avir_statuses_sum * 100
        infected_perc = float(avir_statuses['infected']) / avir_statuses_sum * 100

        if unknown_perc > WARN_PERC or infected_perc > WARN_PERC:
            status = monrun.WARNING
        if unknown_perc > CRIT_PERC or infected_perc > CRIT_PERC:
            status = monrun.CRITICAL

    monrun.report(status, avir_statuses)


if __name__ == "__main__":
    parser = argparse.ArgumentParser(description=("Checking anitvirus statuses"))
    parser.add_argument("-t", dest="avir_type", type=str,
                        default="AVIR", required=False, help="anitvirus type: [AVIR|AVIR2] (default:AVIR)")
    parser.add_argument("--app", dest="app", type=str, default=nwsmtp.NWSMTP_APP, required=False,
                        help="application type: [nwsmtp|nwsmtp-out] (default:nwsmtp)")
    main(parser.parse_args())
