#!/usr/sbin/monpy
# -*- coding: UTF-8 -*-

import argparse
from mail.monitoring.common import monrun
from mail.monitoring.delivery.lib import nwsmtp

WARN_PERC = 10
CRIT_PERC = 20


def main(args):
    status = monrun.OK

    backup_statuses = nwsmtp.get_backup_statuses(app=args.app)
    backup_statuses_sum = sum([i for i in backup_statuses.values()])

    if backup_statuses_sum:
        fault_perc = float(backup_statuses['unknown']) / backup_statuses_sum * 100

        if fault_perc > WARN_PERC:
            status = monrun.WARNING
        if fault_perc > CRIT_PERC:
            status = monrun.CRITICAL

    monrun.report(status, backup_statuses)


if __name__ == "__main__":
    parser = argparse.ArgumentParser(description=("Checking backup statuses"))
    parser.add_argument("--app", dest="app", type=str, default=nwsmtp.NWSMTP_APP, required=False,
                        help="application type: [nwsmtp|nwsmtp-out] (default:nwsmtp)")
    main(parser.parse_args())
