#!/usr/sbin/monpy
# -*- coding: UTF-8 -*-

import argparse
from mail.monitoring.common import monrun
from mail.monitoring.delivery.lib.nwsmtp import get_ratesrv_statuses


DEFAULT_LIMITS = {"crit_count": 100, "crit_percent": 2, "warn_count": 50, "warn_percent": 1}


def main(crit_count, crit_percent, warn_count, warn_percent, interval):
    monrun_status = monrun.OK

    statuses = get_ratesrv_statuses(time=interval)
    statuses_sum = sum([i for i in statuses.values()])

    if statuses_sum:
        error_perc = float(statuses['error']) / statuses_sum * 100

        if error_perc > warn_percent or statuses['error'] > warn_count:
            monrun_status = monrun.WARNING

        if error_perc > crit_percent or statuses['error'] > crit_count:
            monrun_status = monrun.CRITICAL

    monrun.report(monrun_status, statuses)


if __name__ == "__main__":
    parser = argparse.ArgumentParser(
        description=("Checks RateSrv responses"))

    parser.add_argument("--count-crit", type=int, default=DEFAULT_LIMITS["crit_count"],
                        dest="crit_count", help="Bad responses critical count")
    parser.add_argument("--percent-crit", type=int, default=DEFAULT_LIMITS["crit_percent"],
                        dest="crit_percent", help="Bad responses critical percent")
    parser.add_argument("--count-warn", type=int, default=DEFAULT_LIMITS["warn_count"],
                        dest="warn_count", help="Bad responses warning count")
    parser.add_argument("--percent-warn", type=int, default=DEFAULT_LIMITS["warn_percent"],
                        dest="warn_percent", help="Bad responses warning percent")
    parser.add_argument("-t", "--time", dest="interval", type=int, default=60, required=False,
                        help="Time interval(seconds) to perform check for")

    args = parser.parse_args()
    main(**dict(args._get_kwargs()))
