#!/usr/sbin/monpy
# -*- coding: UTF-8 -*-

import argparse
from mail.monitoring.common import monrun
from mail.monitoring.delivery.lib import nwsmtp

DEFAULT_WARNING_COUNT = 40
DEFAULT_WARNING_PERCENT = 2

DEFAULT_CRITICAL_COUNT = 100
DEFAULT_CRITICAL_PERCENT = 5


def main(args):
    status = monrun.OK

    rc_statuses = nwsmtp.get_rc_statuses(app=args.app)
    rc_statuses_sum = sum([i for i in rc_statuses.values()])

    if rc_statuses_sum:
        fail_perc = float(rc_statuses['fail']) / rc_statuses_sum * 100

        if fail_perc > args.percent_warn or rc_statuses['fail'] > args.count_warn:
            status = monrun.WARNING

        if fail_perc > args.percent_crit or rc_statuses['fail'] > args.count_crit:
            status = monrun.CRITICAL

    monrun.report(status, rc_statuses)


if __name__ == "__main__":
    parser = argparse.ArgumentParser(
        description=("Checks RC responses statuses"))
    parser.add_argument("--count-crit", type=int, default=DEFAULT_CRITICAL_COUNT,
                        required=False, help="Bad responses critical count")
    parser.add_argument("--percent-crit", type=int, default=DEFAULT_CRITICAL_PERCENT,
                        required=False, help="Bad responses critical percent")
    parser.add_argument("--count-warn", type=int, default=DEFAULT_WARNING_COUNT,
                        required=False, help="Bad responses warning count")
    parser.add_argument("--percent-warn", type=int, default=DEFAULT_WARNING_PERCENT,
                        required=False, help="Bad responses warning percent")
    parser.add_argument("--app", dest="app", type=str, default=nwsmtp.NWSMTP_APP, required=False,
                        help="application type: [nwsmtp|nwsmtp-out] (default:nwsmtp)")
    main(parser.parse_args())
