#!/usr/sbin/monpy
# -*- coding: UTF-8 -*-

import argparse
from mail.monitoring.common import monrun
from mail.monitoring.delivery.lib import nwsmtp

DEFAULT_BAD_CODES_COUNT = float("inf")
DEFAULT_BAD_CODES_PERCENT = 1
IGNORE_STATUS_CODES = [250]


def main(args, IGNORE_STATUS_CODES):
    status = monrun.OK

    IGNORE_STATUS_CODES += args.ignore_codes

    relay_statuses = nwsmtp.get_relays_statuses(
        time=args.interval, ignore_messages=args.ignore_messages, app=args.app)["relays"][args.relay]

    statuses_count = sum(
        [count for relay_status, count in relay_statuses.iteritems()])

    bad_statuses_count = sum(
        [count for relay_status, count in relay_statuses.iteritems() if relay_status not in IGNORE_STATUS_CODES])

    bad_statuses_percent = 0.0
    if statuses_count:
        bad_statuses_percent = float(bad_statuses_count) / statuses_count * 100

        if bad_statuses_percent > args.percent_crit or bad_statuses_count > args.count_crit:
            status = monrun.CRITICAL

    bad_percent_report = "BAD/TOT: %.2f%%" % bad_statuses_percent
    monrun.report(status, relay_statuses, suffix=bad_percent_report)


if __name__ == "__main__":
    parser = argparse.ArgumentParser(
        description=("Checking nwsmtp's relays smtp codes"))
    parser.add_argument("-t", "--time", dest="interval", type=int, default=60, required=False,
                        help="Time interval(seconds) to perform check for")
    parser.add_argument("-r", "--relay", dest="relay", type=str, default="all_relays",
                        required=False, help="Relay for inspect (default: all_relays)")
    parser.add_argument("-c", "--count-crit", dest="count_crit", type=int, default=DEFAULT_BAD_CODES_COUNT,
                        required=False, help="Bad codes count")
    parser.add_argument("-p", "--percent-crit", dest="percent_crit", type=int, default=DEFAULT_BAD_CODES_PERCENT,
                        required=False, help="Bad codes percent")
    parser.add_argument("-i", "--ignore-messages", dest="ignore_messages", nargs="+", default=(),
                        required=False, help="List of status messages that will be ignore")
    parser.add_argument("--ignore-codes", dest="ignore_codes", nargs="+", default=(), type=int,
                        required=False, help="List of smtp codes that will be ignore")
    parser.add_argument("--app", dest="app", type=str, default=nwsmtp.NWSMTP_APP, required=False,
                        help="application type: [nwsmtp|nwsmtp-out] (default:nwsmtp)")
    args = parser.parse_args()
    main(args, IGNORE_STATUS_CODES)
