#!/usr/sbin/monpy
# -*- coding: UTF-8 -*-

import argparse
from mail.monitoring.common import monrun
from mail.monitoring.delivery.lib import nwsmtp


DEFAULT_LIMITS = {"crit_percent": 10, "warn_percent": 5}


def main(crit_percent, warn_percent, interval, app):
    monrun_status = monrun.OK
    statuses = nwsmtp.get_settings_authorization_statuses(time=interval, app=app)
    statuses_sum = statuses["bypass_by_settings_error"] + statuses["reject_by_pop_and_imap_off"] + \
                   statuses["reject_by_plain_auth_off"] + statuses["accept"]
    if statuses_sum > 0:
        fail_perc = float(statuses["bypass_by_settings_error"]) / statuses_sum * 100
        if fail_perc > crit_percent:
            monrun_status = monrun.CRITICAL
        elif fail_perc > warn_percent:
            monrun_status = monrun.WARNING
    monrun.report(monrun_status, statuses)


if __name__ == "__main__":
    parser = argparse.ArgumentParser(
        description=("Checks Settings authorization statuses"))

    parser.add_argument("--percent-crit", type=int, default=DEFAULT_LIMITS["crit_percent"],
                        dest="crit_percent", help="Bad statuses critical percent")
    parser.add_argument("--percent-warn", type=int, default=DEFAULT_LIMITS["warn_percent"],
                        dest="warn_percent", help="Bad statuses warning percent")
    parser.add_argument("-t", "--time", dest="interval", type=int, default=60, required=False,
                        help="Time interval(seconds) to perform check for")
    parser.add_argument("--app", dest="app", type=str, default=nwsmtp.NWSMTP_APP, required=False,
                        help="application type: [nwsmtp|nwsmtp-out] (default:nwsmtp)")
    args = parser.parse_args()
    main(**dict(args._get_kwargs()))
