#!/usr/sbin/monpy
# -*- coding: UTF-8 -*-

from mail.monitoring.common import monrun
from mail.monitoring.common.maillog import get_maillog
import re

ERRORS_PROC_WARN = 5
ERRORS_PROC_CRIT = 10


def main():
    statuses = {}
    count = 0
    for line in get_maillog():
        if re.search('so_check', line):
            count += 1
            status = line.split('"')[1].split()[1]
            statuses[status] = statuses.get(status, 0) + 1

    errors = statuses.get('error', 0)
    errors_proc = errors / count * 100

    result = 0
    if errors_proc > ERRORS_PROC_WARN:
        result = 1
    if errors_proc > ERRORS_PROC_CRIT:
        result = 1
    if statuses['spam'] > statuses['ham']:
        result = 1
    if statuses['malicious'] > statuses['ham']:
        result = 2

    monrun.report(result, str(statuses))


if __name__ == "__main__":
    main()
