#!/usr/bin/python
# -*- coding: UTF-8 -*-


import json
import subprocess


str_log = 'postqueue -j'.split()
p = subprocess.Popen(str_log, stdout=subprocess.PIPE)
queue = p.communicate()[0].splitlines()

senders = {}
recipients = {}
queue_types = {}

for letter in queue:
    letter = json.loads(letter)
    queue = letter['queue_name']
    queue_types[queue] = queue_types.get(queue, 0) + 1
    sender = letter['sender']
    if senders.get(queue) is None:
        senders[queue] = {}
    if recipients.get(queue) is None:
        recipients[queue] = {}
    senders[queue][sender] = senders[queue].get(sender, 0) + 1
    for recipient in letter['recipients']:
        rcpt = recipient['address']
        recipients[queue][rcpt] = recipients[queue].get(rcpt, 0) + 1


def printQueues(queues, name):
    print "\n=== %s ===" % (name)
    for queue in queues:
        print "  %s" % (queue)
        queue = sorted(queues[queue].items(), key=lambda (k, v): v, reverse=True)[:10]
        for item in queue:
            print "    %s: %d" % (item[0], item[1])


printQueues(recipients, 'Recipients')

printQueues(senders, 'Senders')

print queue_types
