#!/usr/sbin/monpy
# -*- coding: UTF-8 -*-

import argparse
import re
from collections import defaultdict
from mail.monitoring.delivery.lib.postfix import get_queue_data, get_queue_size
from mail.monitoring.common import monrun


# Процент ошибок по домену относительно всей очереди:
DEFAULT_DOMAIN_COUNT_CRIT_PERC = 1
COMMON_ERRORS = ["Connection timed out", 
                 "Connection refused",
                 "Host not found",
                 "Permission denied",
                 "The email account that you tried to reach is over quota",
                 "mx.yandex-team.ru.*Try again later", 
                 "The recipient has exceeded message rate limit"]

RE_COMMON_ERRORS =  [re.compile(error) for error in COMMON_ERRORS]


def print_human_stat(recipient_domains, crit_domain_percent):
    queue_size = get_queue_size("deferred")
    print "Common errors:"
    for error in COMMON_ERRORS:
        print "- %s" % (error)
    for domain, domain_data in recipient_domains.iteritems():
        for deferred_type, count in domain_data.iteritems():
            count_perc = float(count)/float(queue_size)*100
            if count_perc > crit_domain_percent:
                print "%s: %.2f%%: %s errors" % (domain, count_perc, deferred_type)


def print_monrun_report(recipient_domains, crit_domain_percent):
    queue_size = get_queue_size("deferred")

    banned_domains = []
    status = monrun.OK
    for domain, domain_data in recipient_domains.iteritems():
        # Проверку не поджигаем в случае известных проблем с доменом (MAILDLV-5743):
        if domain_data.get("unknown"):
            count_perc = float(domain_data["unknown"])/float(queue_size)*100
            if count_perc > crit_domain_percent:
                banned_domains.append(domain)
                status = monrun.CRITICAL
    monrun.report(status, banned_domains)


def main(args):
    recipient_domains = defaultdict(lambda: defaultdict(int))
        
    for message in get_queue_data():
        for recipient in message["recipients"]:
            deferred_type = "unknown"
            if re.search("@", recipient["address"]):
                recipient_domain = recipient["address"].split("@")[1]
    
                for error in RE_COMMON_ERRORS:
                    if recipient.get("delay_reason") and error.search(recipient["delay_reason"]):
                        deferred_type = "common"

                recipient_domains[recipient_domain][deferred_type] += 1

    if args.monrun:
        print_monrun_report(recipient_domains, args.crit_domain_percent)
    else:
        print_human_stat(recipient_domains, args.crit_domain_percent)


if __name__ == "__main__":
    parser = argparse.ArgumentParser(description=("Check deferred domains"))
    parser.add_argument("-p", "--percent", dest="crit_domain_percent", type=int, default=DEFAULT_DOMAIN_COUNT_CRIT_PERC,
                        help="Crit percent for domain with problem")
    parser.add_argument("--monrun", action="store_true", default=False, help="monrun mode")

    main(parser.parse_args())
