#!/usr/sbin/monpy
# -*- coding: UTF-8 -*-

import argparse
import re
import time
from mail.monitoring.delivery.lib.postfix import get_queue_data, delete_ids


DEFAULT_HOURS_IN_QUEUE = 12

UNDELIVERD_DOMAINS = [".paysys.yandex.net",
                      ".tst.yandex.net", ".yp-c.yandex.net"]
DELAY_REASON = "2a02:6b8.*Permission denied"


def check_message_is_undelivered(message):
    for domain in UNDELIVERD_DOMAINS:
        if len(message["recipients"]) \
            and re.search(domain, message["recipients"][0]["address"]) \
            and re.search(domain, message["sender"]) \
            and re.search(DELAY_REASON, message["recipients"][0].get("delay_reason", "")):
            print message
            return True
    return False


def main(args):
    ids_to_delete = []

    for message in get_queue_data() + get_queue_data(queue_name="hold"):
        if message["sender"] == "MAILER-DAEMON":
            seconds_in_queue = int(time.time()) - message["arrival_time"]
            hours_in_queue = seconds_in_queue/3600
            if hours_in_queue > args.hours_limit:
                ids_to_delete.append(message["queue_id"])
        if args.pre_dsn:
            if check_message_is_undelivered(message):
                ids_to_delete.append(message["queue_id"])

    if len(ids_to_delete):
        delete_ids(ids_to_delete)


if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="Postfix DSN cleaner")
    parser.add_argument("--hours-limit",
                        type=int, default=DEFAULT_HOURS_IN_QUEUE,
                        help="The amount of hours that the message is in the queue")
    parser.add_argument("--pre-dsn", action="store_true", default=False,
                        help="Clean emails before postfix backoff timeout, to prevent DSN")
    args = parser.parse_args()

    main(args)
