#!/bin/bash

SCRIPT_PATH="/usr/share/monitor/yasm/enabled/"
LOG="/var/log/yandex/yasm-sender.log"

UPDATE_PERIOD=10

if [ -f /app/monitoring/yasm/yasmagent.disabled ];then
    SCRIPT_PATH="/app/monitoring/yasm/enabled/"
    LOG="/app/monitoring/yasm/yasm-sender.log"
fi

function send_metrics() {
    for script in $(find $SCRIPT_PATH -type f; find $SCRIPT_PATH -type l;); do
        $script &
    done
}

if [ $((find $SCRIPT_PATH -type f; find $SCRIPT_PATH -type l; 2>/dev/null) | wc -l) -eq 0 ];then
    echo "There's no scripts in "$SCRIPT_PATH
    exit
fi

mkdir -p $(dirname ${LOG})
for (( i=0; i<59; i+=$UPDATE_PERIOD )); do
    send_metrics &>> $LOG
    sleep $UPDATE_PERIOD
done

