#!/usr/bin/env monpy
# -*- coding: UTF-8 -*-

from mail.monitoring.delivery.lib import yasm
from mail.monitoring.common.timetail import timetail
from mail.monitoring.delivery.lib import mdbsave
from mail.monitoring.common.platform import yasm_send_http_stat, yasm_send_http_stat_custom

ITYPE = "mdbsave"

LOG_FILE = "/app/log/mdbsave.tskv"
ACCESS_LOG_FILE = "/app/log/access.tskv"
HTTP_CLIENT_LOG_FILE = "/app/log/http_client.tskv"

TIMETAIL_FMT = "tskv"


if __name__ == "__main__":

    log_cached = timetail(LOG_FILE, fmt=TIMETAIL_FMT)

    def get_log_cached(LOG_FILE, time, fmt):
        return log_cached

    def make_http_client_recognizer():
        services = mdbsave.get_services()
        def recognize(pairs):
            return services.get(pairs.get("host", ""))
        return recognize

    # Access log and http_client log codes and timings:
    yasm_send_http_stat(ACCESS_LOG_FILE, ITYPE)
    yasm_send_http_stat_custom(HTTP_CLIENT_LOG_FILE, ITYPE, http_client_recognizer=make_http_client_recognizer())

    failed_shards = mdbsave.get_errors_count_per_shard(get_logs=get_log_cached)
    db_errors = mdbsave.get_db_errors(get_logs=get_log_cached)
    success_save_count = mdbsave.get_success_save_count(get_logs=get_log_cached)

    yasm.send(failed_shards, prefix="failed_shards", suffix="tmmx", itype=ITYPE)
    yasm.send(db_errors, prefix="db_errors", suffix="tmmx", itype=ITYPE)
    yasm.send({"success_save_count": success_save_count}, prefix="", suffix="tmmx", itype=ITYPE)
