#!/usr/sbin/monpy
# -*- coding: UTF-8 -*-

from mail.monitoring.delivery.lib import yasm
from mail.monitoring.delivery.lib import nsls
from mail.monitoring.common.timetail import timetail
from mail.monitoring.common.platform import yasm_send_http_stat


ITYPE = "nsls"
NSLS_LOG = "/app/log/notsolitesrv.tskv"
ACCESS_LOG = "/app/log/access.tskv"
HTTP_CLIENT_LOG = "/app/log/http_client.tskv"


if __name__ == "__main__":

    nsls_log_cached = timetail(NSLS_LOG, fmt=nsls.TIMETAIL_FMT)

    def get_nsls_log_cached(log, time, fmt):
        return nsls_log_cached

    # Access log and http_client log codes and timings:
    yasm_send_http_stat(ACCESS_LOG, ITYPE)
    yasm_send_http_stat(HTTP_CLIENT_LOG, ITYPE)

    # LMTP reply codes:
    lmtp_codes_stat = nsls.get_reply_codes(get_logs=get_nsls_log_cached)
    yasm.send(lmtp_codes_stat, prefix="lmtp_reply_codes", suffix="tmmx", itype=ITYPE)

    msg_delay_stat = nsls.get_msg_delay_stat(["in", "out", "dlv"], get_logs=get_nsls_log_cached, raw_timings=True)
    yasm.send(msg_delay_stat, prefix="msg_delay", suffix="ahhh", itype=ITYPE)
