#!/usr/bin/env monpy
# -*- coding: UTF-8 -*-

import re
from mail.monitoring.common.timetail import timetail
from mail.monitoring.common.platform import yasm_send_http_stat
from mail.monitoring.delivery.lib import nwsmtp
from mail.monitoring.delivery.lib import yasm
from os.path import isfile


def process_logs(http_client_log_path, nwsmtp_log_path, access_log_path, yplatform_log_cached, app):
    http_client_log_cached = timetail(log_file=http_client_log_path, fmt=nwsmtp.TIMETAIL_FMT)

    def get_http_client_log_cached(log_file, fmt, time):
        return http_client_log_cached

    nwsmtp_log_cached = timetail(log_file=nwsmtp_log_path, fmt=nwsmtp.TIMETAIL_FMT)

    def get_nwsmtp_log_cached(log_file, fmt, time):
        return nwsmtp_log_cached

    def get_nwsmtp_access_log_cached(log_file, fmt, time):
        return nwsmtp_access_log_cached

    def get_yplatform_log_cached(log_file, time):
        return yplatform_log_cached

    # SO:
    so_statuses_metrics = nwsmtp.get_so_statuses(get_logs=get_nwsmtp_log_cached)
    yasm.send(so_statuses_metrics, prefix="so_status", suffix="tmmx", itype=app)

    # Fouras:
    fouras_statuses_metrics = {}
    for status, descriptions in nwsmtp.get_fouras_statuses(get_logs=get_nwsmtp_log_cached).iteritems():
        fouras_statuses_metrics[status] = sum([i for i in descriptions.values()])
    yasm.send(fouras_statuses_metrics, prefix="fouras_status", suffix="tmmx", itype=app)

    fouras_timings = nwsmtp.get_fouras_timings(get_logs=get_nwsmtp_log_cached)
    yasm.send({"fouras_timings": fouras_timings}, prefix="", suffix="ahhh", itype=app)

    # RateSrv
    ratesrv_statuses_metrics = nwsmtp.get_ratesrv_statuses(get_logs=get_yplatform_log_cached)
    yasm.send(ratesrv_statuses_metrics, prefix="ratesrv_status", suffix="tmmx", itype=app)

    ratesrv_timings = nwsmtp.get_ratesrv_timings(get_logs=get_yplatform_log_cached)
    yasm.send({"ratesrv_timings": ratesrv_timings}, prefix="", suffix="ahhh", itype=app)

    # Connection rejects
    connection_statuses_metrics = nwsmtp.get_connection_reject_statuses(get_logs=get_nwsmtp_log_cached)
    yasm.send(connection_statuses_metrics, prefix="smtp_connection_status", suffix="tmmx", itype=app)

    # Sender rejects
    sender_statuses_metrics = nwsmtp.get_sender_reject_statuses(get_logs=get_nwsmtp_log_cached)
    yasm.send(sender_statuses_metrics, prefix="smtp_mailfrom_status", suffix="tmmx", itype=app)

    # Recipient rejects
    recipient_statuses_metrics = nwsmtp.get_recipient_reject_statuses(get_logs=get_nwsmtp_log_cached)
    yasm.send(recipient_statuses_metrics, prefix="smtp_rcptto_status", suffix="tmmx", itype=app)

    # AVIR/Eset:
    # == all avir metrics:
    avir_statuses_metrics = nwsmtp.get_avir_statuses("AVIR", get_logs=get_nwsmtp_log_cached)
    yasm.send(avir_statuses_metrics, prefix="avir_status", suffix="tmmx", itype=app)

    avir_timings = nwsmtp.get_avir_timings("AVIR", get_logs=get_nwsmtp_log_cached)
    yasm.send({"avir_timings": avir_timings}, prefix="", suffix="ahhh", itype=app)

    # == all eset metrics:
    eset_statuses_metrics = nwsmtp.get_avir_statuses("AVIR2", get_logs=get_nwsmtp_log_cached)
    yasm.send(eset_statuses_metrics, prefix="eset_status", suffix="tmmx", itype=app)

    eset_timings = nwsmtp.get_avir_timings("AVIR2", get_logs=get_nwsmtp_log_cached)
    yasm.send({"eset_timings": eset_timings}, prefix="", suffix="ahhh", itype=app)

    # == yavs metrics:
    yavs_statuses_metrics = nwsmtp.get_avir_statuses("AVIR", get_logs=get_nwsmtp_log_cached, host="mail-in.slb.av.yandex.net:1344")
    yasm.send(yavs_statuses_metrics, prefix="yavs_status", suffix="tmmx", itype=app)

    yavs_timings = nwsmtp.get_avir_timings("AVIR", get_logs=get_nwsmtp_log_cached, host="mail-in.slb.av.yandex.net:1344")
    yasm.send({"yavs_timings": yavs_timings}, prefix="", suffix="ahhh", itype=app)

    # ==  yavs-out metrics:
    yavs_out_statuses_metrics = nwsmtp.get_avir_statuses("AVIR", get_logs=get_nwsmtp_log_cached, host="mail-out.slb.av.yandex.net:1344")
    yasm.send(yavs_out_statuses_metrics, prefix="yavs_out_status", suffix="tmmx", itype=app)

    yavs_out_timings = nwsmtp.get_avir_timings("AVIR", get_logs=get_nwsmtp_log_cached, host="mail-out.slb.av.yandex.net:1344")
    yasm.send({"yavs_out_timings": yavs_out_timings}, prefix="", suffix="ahhh", itype=app)

    # == yavs-corp metrics:
    yavs_statuses_metrics = nwsmtp.get_avir_statuses("AVIR", get_logs=get_nwsmtp_log_cached, host="mail-corp.slb.av.yandex.net:1344")
    yasm.send(yavs_statuses_metrics, prefix="yavs_status", suffix="tmmx", itype=app)

    yavs_timings = nwsmtp.get_avir_timings("AVIR", get_logs=get_nwsmtp_log_cached, host="mail-corp.slb.av.yandex.net:1344")
    yasm.send({"yavs_timings": yavs_timings}, prefix="", suffix="ahhh", itype=app)

    # Relay codes:
    relay_statuses_metrics = {}
    for relay, codes in nwsmtp.get_relays_statuses(get_logs=get_nwsmtp_log_cached)["relays"].iteritems():
        relay = re.sub(":", "_", relay)
        for code, count in codes.iteritems():
            metric = "%s_%d" % (relay, code)
            relay_statuses_metrics[metric] = count
    yasm.send(relay_statuses_metrics, prefix="relay_status", suffix="tmmx", itype=app)

    # Access log and http_client log codes and timings:
    yasm_send_http_stat(access_log_path, app)
    yasm_send_http_stat(http_client_log_path, app)

    # Control from stat:
    hdr_from_stat = nwsmtp.get_hdr_from_stat(get_logs=get_nwsmtp_log_cached)
    yasm.send(hdr_from_stat["statuses"], prefix="hdr_from_statuses", suffix="tmmx", itype=app)
    hdr_from_errors = {}
    for error, count in hdr_from_stat["errors"].iteritems():
        error = re.sub(" ", "_", error)
        hdr_from_errors[error] = count
    yasm.send(hdr_from_errors, prefix="hdr_from_errors", suffix="tmmx", itype=app)

    # Settings:
    settings_statuses_metrics = {}
    for status, descriptions in nwsmtp.get_settings_statuses(get_logs=get_nwsmtp_log_cached).iteritems():
        settings_statuses_metrics[status] = sum([i for i in descriptions.values()])
    yasm.send(settings_statuses_metrics, prefix="settings_status", suffix="tmmx", itype=app)

    # Settings authorization:
    settings_authorization_metrics = nwsmtp.get_settings_authorization_statuses(
        get_logs=get_nwsmtp_log_cached)
    yasm.send(settings_authorization_metrics, prefix="settings_authorization_status", suffix="tmmx",
              itype=app)

    # SMTP reply codes:
    smtp_codes_stat = nwsmtp.get_smtp_codes(get_logs=get_nwsmtp_log_cached)
    yasm.send(smtp_codes_stat, prefix="smtp_reply_codes", suffix="tmmx", itype=app)

if __name__ == "__main__":
    nwsmtp_access_log_cached = timetail(log_file=nwsmtp.NWSMTP_ACCESS_LOG_PATH,
                                        fmt=nwsmtp.TIMETAIL_FMT)
    yplatform_log_cached = timetail(log_file=nwsmtp.YPLATFORM_LOG_PATH)
    process_logs(http_client_log_path=nwsmtp.HTTP_CLIENT_IN_LOG_PATH,
                 nwsmtp_log_path=nwsmtp.NWSMTP_IN_LOG_PATH,
                 access_log_path=nwsmtp.NWSMTP_ACCESS_LOG_PATH,
                 yplatform_log_cached=yplatform_log_cached,
                 app=nwsmtp.NWSMTP_APP)
    if isfile("/etc/nwsmtp/config-out.yml"):
        process_logs(http_client_log_path=nwsmtp.HTTP_CLIENT_OUT_LOG_PATH,
                     nwsmtp_log_path=nwsmtp.NWSMTP_OUT_LOG_PATH,
                     access_log_path=nwsmtp.NWSMTP_ACCESS_LOG_PATH,
                     yplatform_log_cached=yplatform_log_cached,
                     app=nwsmtp.NWSMTP_OUT_APP)
