#!/usr/sbin/monpy
# -*- coding: UTF-8 -*-

from mail.monitoring.delivery.lib import yasm
from mail.monitoring.delivery.lib.common import get_delivery_statuses
from mail.monitoring.delivery.lib.postfix import get_queue_size, get_sent_timings

ITYPE = "postfix"

POSTFIX_QUEUES = ["active", "deferred", "hold", "incoming", "autohold", "mailer_daemon"]

queue_data = {}
for queue in POSTFIX_QUEUES:
    queue_data[queue] = get_queue_size(queue)


delivery_statuses_metrics = get_delivery_statuses(app="postfix")
sent_timings = get_sent_timings()

yasm.send(queue_data, prefix="mailq", suffix="tmmx", itype=ITYPE)
yasm.send(delivery_statuses_metrics, prefix="status", suffix="tmmx", itype=ITYPE)
yasm.send({"sent_timings": sent_timings}, prefix="", suffix="ahhh", itype=ITYPE)
