#!/usr/bin/env monpy
# -*- coding: UTF-8 -*-

from mail.monitoring.delivery.lib import yasm, smtpgate
from mail.monitoring.common.platform import get_http_info

ITYPE = "smtpgate"

if __name__ == "__main__":

    # Server codes:
    request_codes = {}
    request_timings = {}
    for request, request_data in get_http_info("/var/log/smtpgate/access.log", raw_timings=True).iteritems():
        for code, count in request_data["http_codes"].iteritems():
            request_code = "%s_%s" % (request, code)
            request_codes[request_code] = count
        request_timings[request] = request_data["timings"]

    yasm.send(request_codes, prefix="smtpgate_code", suffix="tmmx", itype=ITYPE)
    yasm.send(request_timings, prefix="smtpgate_timings", suffix="ahhh", itype=ITYPE)

    # Cliet codes:
    http_client_stat = smtpgate.get_http_client_stat(get_logs=smtpgate.get_smtpgate_log, yasm_format=True)
    yasm.send(http_client_stat["http_codes"], prefix="http_client_codes", suffix="tmmx", itype=ITYPE)
    yasm.send(http_client_stat["http_timings"], prefix="http_client_timings", suffix="ahhh", itype=ITYPE)
