#!/usr/bin/python
# -*- coding: UTF-8 -*-


import datetime
import json
import os
import requests
import time
from escalations_settings import SETTINGS, get_namespace_cache_file


def save_escalations_stat(escalations, filename):
    with open(filename, "w") as f:
        f.write(json.dumps(escalations))


def save_history_escalations(namespace):
    current_time = int(time.time())
    escalations = []
    escalation_ids = []
    page_counter = 0
    is_recent = True
    today = datetime.date.today()
    days_from_monday = datetime.datetime.today().isoweekday()
    monday_midnight = today - datetime.timedelta(days=days_from_monday - 1)
    monday_midnight_ts = time.mktime(monday_midnight.timetuple())
    while is_recent:
        post_data = json.loads(SETTINGS["GET_ESALATIONS_DATA"])
        post_data["page"] = page_counter
        post_data["filters"][0]["namespace"] = namespace
        print post_data
        for esc in requests.post(SETTINGS["API_URL"], data=json.dumps(post_data)).json()["escalations"]:
            if int(esc["start_time"]) < monday_midnight_ts:
                is_recent = False
                continue
            if esc.get("stopped"):
                if int(esc["start_time"]) > monday_midnight_ts and esc["escalation_id"] not in escalation_ids:
                    escalations.append(esc)
                    escalation_ids.append(esc["escalation_id"])
        page_counter += 1
    save_escalations_stat(escalations, get_namespace_cache_file(namespace))



def main():
    if not os.path.exists(SETTINGS["HISTORY_CACHE_DIR"]):
        os.makedirs(SETTINGS["HISTORY_CACHE_DIR"])

    for namespace in SETTINGS["NAMESPACES"]:
        print namespace
        save_history_escalations(namespace)


if __name__ == "__main__":
   main()
