<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
        <link rel="stylesheet" href="./static/bootstrap.min.css"/>
    </head>
    <body>
    <script src="./static/jquery-3.2.1.slim.min.js"></script>
    <script src="./static/popper.min.js"></script>
    <script src="./static/bootstrap.min.js"></script>

    <script type="text/javascript" src="./static/daterangepicker/moment.min.js"></script>
    <script type="text/javascript" src="./static/daterangepicker/daterangepicker.min.js"></script>
    <link rel="stylesheet" type="text/css" href="./static/daterangepicker/daterangepicker.css" />

    <style type="text/css">
      .daterange {
        width: 190px;
        padding: 3px;
        font-size: 10pt;
        margin-top: 7px;
      }
    </style>

    %if route in ("stat", "top_stopped", "new"):
      <script>
      $(function() {
        $('input[name="daterange"]').daterangepicker({
              "locale": {
              "format": "YYYY-MM-DD",
              "separator": " 一 ",
              "applyLabel": "Apply",
              "cancelLabel": "Cancel",
              "fromLabel": "From",
              "toLabel": "To",
              "customRangeLabel": "Custom",
              "weekLabel": "W",
              "firstDay": 1,
          },
          "autoApply": true,
          "startDate": "{{daterange['date_from']}}",
          "endDate": "{{daterange['date_to']}}",
          opens: 'left'
        }, function(start, end, label) {
          console.log("A new date selection was made: " + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD'));
        });
      });
      </script>
    %end

    %all_stopped_active = ""
    %top_stopped_active = ""
    %menu_disabled = ""
    %if sort_type:
      %if sort_type == "all":
          %all_stopped_active = "active"
      %end
      %if sort_type == "top":
          %top_stopped_active = "active"
      %end
    %end
    %if not abc_service:
        %abc_service = "ABC"
        %menu_disabled = "disabled"
    %end

    %phone_checked = ""
    %telegram_checked = ""
    %if methods.get("phone_escalation"):
        %phone_checked = "checked"
    %end
    %if methods.get("telegram"):
        %telegram_checked = "checked"
    %end


    <ul class="nav nav-tabs">
      <a class="navbar-brand" href="#">JugglerStat</a>
          <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" href="#" id="navbarDropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">{{ abc_service }} </a>
            <div class="dropdown-menu" aria-labelledby="navbarDropdownMenuLink">
              %for abc in abc_services:
                <a class="dropdown-item" href="?abc_service={{abc}}">{{abc}}</a>
              %end
            </div>
          </li>
          <a class="nav-item nav-link {{all_stopped_active}} {{menu_disabled}}" 
          href="/stat?abc_service={{abc_service}}&sort=all&daterange={{daterange_link}}"> All stopped escalations</a>
          <a class="nav-item nav-link {{top_stopped_active}} {{menu_disabled}}" 
          href="/stat?abc_service={{abc_service}}&sort=top&daterange={{daterange_link}}">Top stopped escalations</a>
          <a class="nav-item nav-link disabled" href="#" tabindex="-1" aria-disabled="true">All escalations</a>
          %if route == "stat":
            <form method="GET" action="{{route}}">
              <input type="hidden" name="abc_service" value="{{abc_service}}" />
              <input type="hidden" name="sort" value="{{sort_type}}" />
              <input type="text" name="daterange" class="daterange" />
              <div class="form-check form-check-inline">
                <input class="form-check-input" type="checkbox" id="phone_escalation" name="phone_escalation" value="1" {{phone_checked}}>
                <label class="form-check-label" for="phone_escalation">phone</label>
              </div>
              <div class="form-check form-check-inline">
                <input class="form-check-input" type="checkbox"  id="telegram" name="telegram" value="1" {{telegram_checked}}>
                <label class="form-check-label" for="telegram">telegram</label>
              </div>
              <button type="submit" class="btn btn-primary btn-sm">Apply</button>
            </form>
          %end
    </ul>
    <center>
     %if route == "stat":
        %if sort_type == "all":
            %include("all_escalations.tpl")
        %end
        %if sort_type == "top":
            %include("top_escalations.tpl")
        %end
     %end
    </body>
</html>
