#!/usr/bin/python
# -*- coding: UTF-8 -*-

import collections
import requests
import json
from mail.monitoring.common import abc
from mail.monitoring.juggler.notifications.lib.send_mail import send_mail

JUGGLER_API_HOST = "https://juggler-api.search.yandex.net"


def update_notify_rule(oauth_token, logins, rule_id, namespace, delay=600, call_tries=2, on_success_next_call_delay=60):
    """
    Example:
    update_notify_rule_logins(OAUTH_TOKEN, ["pierre"], "5e330f002c7c440076d57acc", "mail.delivery.database")
    """

    auth_headers = {"Authorization": "OAuth " + oauth_token}
    update_data = {
        "namespace": namespace,
        "selector": "namespace=" + namespace,
        "rule_id": rule_id,
        "template_name": "phone_escalation",
        "template_kwargs": {
            "logins": logins,
            "delay": delay,
            "call_tries": call_tries,
            "on_success_next_call_delay": on_success_next_call_delay,
        }
    }
    return requests.post(JUGGLER_API_HOST + "/api/notify_rules/add_or_update_notify_rule?do=1", data=json.dumps(update_data), headers=auth_headers)


def get_duties_from_notify_rule(rule_id):
    request_data = {
        "filters": [
            {
                "rule_id": rule_id
            }
        ]
    }
    juggler_ans = requests.post(JUGGLER_API_HOST + "/api/notify_rules/get_notify_rules?do=1", data=json.dumps(request_data))
    return juggler_ans.json()["rules"][0]["template_kwargs"]["logins"]


def rotate_duties_in_notify_rule(abc_id, abc_token, namespace, notify_rule_id, juggler_token):
    # Получаем список дежурных из ABC:
    abc_duties = abc.get_current_duties(abc_id, abc_token)[0]
    abc_duties_order = abc_duties["schedule"]["orders"]
    abc_current_duty = abc_duties["person"]["login"]

    # Формируем список дежурных для Juggler на основании списка из ABC:
    duties_order = {}
    for duty in abc_duties_order:
        if duty["person"]["login"] != abc_current_duty:
            duties_order[duty["order"]] = duty["person"]["login"]
    duties_order = [abc_current_duty] + collections.OrderedDict(list(duties_order.items())).values()
    # Для инвертирования списка дежурных:
    # duties_order = [abc_current_duty] + \
    #     collections.OrderedDict(reversed(list(duties_order.items()))).values()

    # Сравниваем текущий список в Juggler и "приготовленный" список из ABC:
    juggler_duties = get_duties_from_notify_rule(notify_rule_id)
    if juggler_duties == duties_order:
        return {"no_changes": True}

    juggler_ans = update_notify_rule(juggler_token, duties_order, notify_rule_id, namespace)
    send_mail(abc_id, notify_rule_id, duties_order)
    return dict(juggler_ans.json())
