from os import environ
from library.python.vault_client.instances import Production as VaultClient
from mail.monitoring.juggler.notifications import rotate_duties_in_notify_rule
from mail.monitoring.juggler.notifications.config import ROTATOR_CONFIGS


ROBOT_GERRIT_SECRET_ID = "sec-01d34s477p8fak79sq374swfqa"

yav_client = VaultClient(decode_files=True, authorization='OAuth {}'.format(
    environ.get("YAV_AUTH_TOKEN")))
secrets = yav_client.get_version(ROBOT_GERRIT_SECRET_ID)

abc_auth_token = secrets["value"]["abc.oauth.token"]
juggler_auth_token = secrets["value"]["juggler.oauth.token"]


for notify_config in ROTATOR_CONFIGS:
    juggler_result = rotate_duties_in_notify_rule(notify_config["abc_id"],
                                                  abc_auth_token,
                                                  notify_config["namespace"],
                                                  notify_config["notify_rule_id"],
                                                  juggler_auth_token)
    print juggler_result
