import re
from email.mime.multipart import MIMEMultipart
from email.mime.text import MIMEText
from smtplib import SMTP
from mail.monitoring.juggler.notifications.lib.eml_template import EML_TEMPLATE


def prepare_template(abc_id, notify_rule_id, duties_order, EML_TEMPLATE):
    duties_html = ""
    for duty in duties_order:
        duties_html += "<li>" + duty + "</li>\n"
    EML_TEMPLATE = re.sub("ABC_ID", str(abc_id), EML_TEMPLATE.decode('utf-8'))
    EML_TEMPLATE = re.sub("DUTIES_ORDER", duties_html, EML_TEMPLATE)
    EML_TEMPLATE = re.sub("RULE_ID", str(notify_rule_id), EML_TEMPLATE)
    return EML_TEMPLATE


def send_mail(abc_id, notify_rule_id, duties_order):
    recipients = [i + "@yandex-team.ru" for i in duties_order]

    msg = MIMEMultipart("alternative")
    msg["From"] = "robot-gerrit@yandex-team.ru"
    msg["To"] = ", ".join(recipients)
    msg["Subject"] = "Ротация дежурных"

    eml_body = prepare_template(abc_id, notify_rule_id, duties_order, EML_TEMPLATE)
    msg.attach(MIMEText(eml_body, 'html', "utf-8"))

    server = SMTP("outbound-relay.yandex.net")
    server.sendmail(msg["From"], recipients, msg.as_string())
