#pragma once

#include <yplatform/task_context.h>

namespace mops {

struct Context : public yplatform::task_context {
    Context(const std::string& uniqId = "", const std::string& requestId = "")
        : yplatform::task_context(uniqId), requestId_(requestId) {}

    const std::string& requestId() { return requestId_; }

private:
    std::string requestId_;
};

using ContextPtr = boost::shared_ptr<Context>;

}
