#pragma once

#include <butil/http/error.h>
#include <macs/types.h>
#include <logdog/attributes/mail_attributes.h>
#include <logdog/format/tskv.h>

namespace mops::logdog {

using namespace ::logdog::attr;
using namespace ::logdog::attr::mail;

LOGDOG_DEFINE_ATTRIBUTE(int, try_number)
LOGDOG_DEFINE_ATTRIBUTE(std::string, conn_info)
LOGDOG_DEFINE_ATTRIBUTE(int, code)
LOGDOG_DEFINE_ATTRIBUTE(unsigned, http_code)
LOGDOG_DEFINE_ATTRIBUTE(std::string, url)
LOGDOG_DEFINE_ATTRIBUTE(std::string, service)
LOGDOG_DEFINE_ATTRIBUTE(std::string, method)
LOGDOG_DEFINE_ATTRIBUTE(std::string, body)
LOGDOG_DEFINE_ATTRIBUTE(std::size_t, actual_size)

LOGDOG_DEFINE_ATTRIBUTE(http::StatusError, status_error)
LOGDOG_DEFINE_ATTRIBUTE(http::error, http_error)

LOGDOG_DEFINE_ATTRIBUTE(macs::Mid, mid)
LOGDOG_DEFINE_ATTRIBUTE(macs::Stid, stid)

template <typename Logger, typename ContextPtr>
inline auto makeContextLogger(Logger&& logger, ContextPtr ctx) {
    std::string uniqId = ctx ? ctx->uniq_id() : "";
    std::string requestId = ctx ? ctx->requestId() : "";
    return ::logdog::bind(std::forward<Logger>(logger), context_id=uniqId, request_id=requestId);
}

} // namespace mops::logdog

namespace logdog::tskv {

template <>
struct to_tskv_impl<http::error> {
    template <typename Out>
    static void apply(Out& out, const char* key, const http::error &e) {
        std::string name = key;
        out << ytskv::attr(name + ".host", e.url().server() + ":" + std::to_string(e.url().port()))
            << ytskv::attr(name + ".reason", e.what());
    }
};

template <>
struct to_tskv_impl<http::StatusError> {
    template <typename Out>
    static void apply(Out& out, const char* key, const http::StatusError& e) {
        std::string name = key;
        out << ytskv::attr(name + ".host", e.url().server() + ":" + std::to_string(e.url().port()))
            << ytskv::attr(name + ".status", e.status())
            << ytskv::attr(name + ".reason", e.what());
    }
};

} // namespace logdog::tskv