#pragma once

#include <boost/asio/spawn.hpp>
#include <yplatform/reactor.h>

#include <mailbox_oper/params.h>

namespace mbox_oper {

template <typename Handler>
void spawn(yplatform::reactor& reactor, Handler&& handler) {
    boost::asio::spawn(*reactor.io(), std::forward<Handler>(handler));
}

template <typename Handler>
void spawn(Handler&& handler) {
    const auto reactor = yplatform::find_reactor("global");
    spawn(*reactor, std::forward<Handler>(handler));
}

} // namespace mbox_oper
