#pragma once

#include <internal/server/request_context.h>
#include <mail/tvm_guard/ymod_tvm/ymod_tvm.h>
#include <tvm_guard/log_tskv.h>
#include <mailbox_oper/logger.h>
#include <ymod_taskmaster/types.hpp>

namespace mbox_oper {
namespace log {

using namespace ::logdog::attr::tvm_guard;

LOGDOG_DEFINE_ATTRIBUTE(std::string, path)
LOGDOG_DEFINE_ATTRIBUTE(std::string, args)

LOGDOG_DEFINE_ATTRIBUTE(std::string, action)
LOGDOG_DEFINE_ATTRIBUTE(std::string, reason)
LOGDOG_DEFINE_ATTRIBUTE(ymod_taskmaster::TaskType, operation)
LOGDOG_DEFINE_ATTRIBUTE(ymod_taskmaster::TaskGroupId, task_group_id)
LOGDOG_DEFINE_ATTRIBUTE(std::size_t, upper_bound)

} // namespace log

inline auto getTvmGuardLogger(ContextPtr ctx) {
    auto logger = std::make_shared<yplatform::log::source>(YGLOBAL_LOG_SERVICE, "tvm_guard");
    return log::makeContextLogger(::logdog::make_log(log::formatter, std::move(logger)), std::move(ctx));
}

} // namespace mbox_oper

namespace logdog::tskv {

template <>
struct to_tskv_impl<ymod_taskmaster::TaskType> {
    template <typename Out>
    static void apply(Out& out, const char* key, const ymod_taskmaster::TaskType& v) {
        out << ytskv::attr(key, ymod_taskmaster::toString(v));
    }
};

} // namespace logdog::tskv
