#pragma once

#include <internal/server/base_handler.h>
#include <internal/server/parse_params.h>
#include <internal/async_api.h>
#include <ymod_taskmaster/task.hpp>

namespace mbox_oper {

template <typename OperationTaskType>
class BaseAsyncOperationHandler : public BaseHandler {
public:
    void execute(RequestContext& req, YieldCtx yield) const override final {
        using Params = typename OperationTaskType::ParamsType;
        using Traits = ParamsTraits<Params>;

        MailboxOperParams commonParams = parseCommonParams(req);
        MailboxOper moperApi = moperModule_->api(commonParams, req.context(), yield);
        auto source = parseMidsSource(req);
        auto params = Traits::parse(req);

        const auto validationError = source->validate();
        if (validationError) {
            logError(req, validationError.get());
            throw ParamsException(validationError.get());
        }

        MailboxOperAsyncApi asyncApi(moperApi, commonParams, req.context());
        const auto res = asyncApi.execute<OperationTaskType>(std::move(params), std::move(source), yield);
        req.responseSuccess(res);
    }
};

} // mbox_oper namespace
