#pragma once

#include <mailbox_oper/config.h>
#include <mailbox_oper/module.h>
#include <internal/server/request_context.h>
#include <internal/logger.h>
#include <yplatform/find.h>
#include <internal/async_support.h>

namespace mbox_oper {

class BaseHandler {
public:
    BaseHandler()
        : moperModule_(yplatform::find<MailboxOperModule>("mailbox_oper")) {
    }

    virtual ~BaseHandler() = default;

    virtual std::string name() const = 0;
    virtual ymod_webserver::methods::http_method method() const = 0;

    void process(ymod_webserver::response_ptr response) const;
    void process(RequestContext request, YieldCtx yield) const;

protected:
    virtual void execute(RequestContext& req, YieldCtx yield) const = 0;

    void logError(const RequestContext& req, const std::string& msg) const {
        LOGDOG_(getContextLogger(req.context()), error, log::method=name(), log::message=msg);
    }

    MailboxOperModulePtr moperModule_;

private:
    void logArguments(const RequestContext& req) const;
};

}

