#pragma once

#include <mailbox_oper/mailbox_oper_routines.h>
#include <internal/server/request_context.h>
#include <internal/server/parse_params.h>
#include <internal/server/base_handler.h>

namespace mbox_oper {

class BaseUpdateHandler: public BaseHandler {
public:
    void execute(RequestContext& req, YieldCtx yield) const override {
        MailboxOperParams commonParams = parseCommonParams(req);
        auto mailboxOper = moperModule_->api(commonParams, req.context(), yield);
        doUpdate(mailboxOper, req, yield);
        req.responseSuccess();
    }

protected:
    virtual void doUpdate(MailboxOper& maiboxOper, const RequestContext& req,
                          YieldCtx yield) const = 0;
};

} // namespace mbox_oper
