#ifndef MBOX_OPER_FOLDERS_OUTPUT_REFLECTION_H
#define MBOX_OPER_FOLDERS_OUTPUT_REFLECTION_H

#include <yamail/data/serialization/json_writer.h>
#include <macs/folder.h>
#include <macs/label.h>

namespace mbox_oper {

struct FolderReflection {
    std::string fid;

    FolderReflection(const macs::Folder& folder)
        : fid(folder.fid())
    {}
};

inline std::string toString(const FolderReflection& folder) {
    return yamail::data::serialization::toJson(folder).str();
}

struct LabelReflection {
    std::string lid;

    LabelReflection(const macs::Label& label)
        : lid(label.lid())
    {}
};

inline std::string toString(const LabelReflection& label) {
    return yamail::data::serialization::toJson(label).str();
}

} // namespace mbox_oper

BOOST_FUSION_ADAPT_STRUCT(mbox_oper::FolderReflection,
    (std::string, fid)
)

BOOST_FUSION_ADAPT_STRUCT(mbox_oper::LabelReflection,
    (std::string, lid)
)

#endif // MBOX_OPER_FOLDERS_OUTPUT_REFLECTION_H
