#pragma once

#include <mailbox_oper/params.h>
#include <ymod_taskmaster/service.hpp>
#include <mail/mops/include/internal/server/request_context.h>
#include <macs/tabs_map.h>

namespace mbox_oper {

std::list<std::string> getList(const RequestContext& req, const std::string& key);
MidsSourcePtr createFidSource(Fid fid, const RequestContext& req);
MidsSourcePtr parseMidsSource(const RequestContext& req);

std::string getStatus(const RequestContext& req);
bool shouldReportToPostmaster(const RequestContext& req);
Fid getDestFid(const RequestContext& req);
OptBool getWithSent(const RequestContext& req);
Lids getLids(const RequestContext& req);
Fids getFids(const RequestContext& req);
bool shouldMove(const RequestContext& req);

MailboxOperParams parseCommonParams(const RequestContext& req);

template <typename Param>
struct ParamsTraits;

template <>
struct ParamsTraits<SpamParams> {
    static SpamParams parse(const RequestContext& req);
};

template <>
struct ParamsTraits<UnspamParams> {
    static UnspamParams parse(const RequestContext& req);
};

template <>
struct ParamsTraits<PurgeParams> {
    static PurgeParams parse(const RequestContext& req);
};

template <>
struct ParamsTraits<RemoveParams> {
    static RemoveParams parse(const RequestContext& req);
};

template <>
struct ParamsTraits<TrashParams> {
    static TrashParams parse(const RequestContext& req);
};

template <>
struct ParamsTraits<MoveParams> {
    static MoveParams parse(const RequestContext& req);
};

template <>
struct ParamsTraits<ComplexMoveParams> {
    static ComplexMoveParams parse(const RequestContext& req);
};

template <>
struct ParamsTraits<MarkParams> {
    static MarkParams parse(const RequestContext& req);
};

template <>
struct ParamsTraits<LabelParams> {
    static LabelParams parse(const RequestContext& req);
};

template <>
struct ParamsTraits<UnlabelParams> {
    static UnlabelParams parse(const RequestContext& req);
};

template <>
struct ParamsTraits<DeleteLabelParams> {
    static DeleteLabelParams parse(const RequestContext& req);
};

template <>
struct ParamsTraits<DeleteFolderParams> {
    static DeleteFolderParams parse(const RequestContext& req);
};

} // namespace

