#pragma once

#include <ymod_taskmaster/service.hpp>

namespace mbox_oper {

enum class OperType {
    Sync,
    Async
};

inline const char* toString(const OperType type) {
    switch(type) {
        case OperType::Sync:
            return "sync";
        case OperType::Async:
            return "async";
    }

    throw std::runtime_error("Invalid OperType value");
}

struct TaskTraits {
    using GroupId = ymod_taskmaster::TaskGroupId;
    using OptGroupId = boost::optional<GroupId>;
    using Type = OperType;
    using Self = TaskTraits;

    Type type;
    OptGroupId groupId;

    static Self sync() noexcept { return Self(Type::Sync); }
    static Self async(const GroupId groupId) noexcept {
        return Self(Type::Async, groupId);
    }

    const char* typeName() const noexcept {
        return toString(type);
    }

private:
    TaskTraits(const Type type, const OptGroupId groupId = OptGroupId()) noexcept
        : type(type),
          groupId(groupId)
    {}
};

}
