#pragma once

#include <boost/uuid/uuid.hpp>
#include <boost/uuid/uuid_generators.hpp>
#include <boost/uuid/uuid_io.hpp>
#include <boost/lexical_cast.hpp>
#include <util/system/tls.h>

namespace mops::helpers {

template<typename T>
T getUuid() {
    Y_STATIC_THREAD(boost::uuids::random_generator) gen;
    return boost::lexical_cast<T>(TlsRef(gen)());
}

}
